// Mob Grup Arama hem grup adı hem mob id ile filtreler ve Türkçe karakter desteği ile çalışır.
document.addEventListener("DOMContentLoaded", function() {
    // Satır hover efekti (ana ve modal)
    function setRowHover() {
        document.querySelectorAll('#dropTable tbody tr').forEach(function(row){
            row.addEventListener('mouseenter', function(){
                row.style.background = "#e8f3ff";
            });
            row.addEventListener('mouseleave', function(){
                row.style.background = "";
            });
        });
    }

    // Bildirim fonksiyonu (toast + ses)
    window.showToast = function(msg) {
        var toast = document.createElement('div');
        toast.className = 'toast-notify toast-success';
        toast.innerHTML = '<span class="toast-icon">&#10003;</span>' +
            '<span>' + msg + '</span>' +
            '<span class="toast-close" title="Kapat" onclick="this.parentElement.remove();">&times;</span>';
        var area = document.getElementById("toastArea");
        if (area) area.appendChild(toast);
        var snd = document.getElementById("successSound");
        if (snd) {
            try { snd.currentTime = 0; snd.play(); } catch(e){}
        }
        setTimeout(function(){ toast.remove(); }, 3500);
    };

    // Türkçe karakterleri normalize eden fonksiyon
    function turkishLower(str) {
        // Türkçe karakterlerin küçük harfe dönüştürülmesi
        const letters = {
            "İ": "i", "I": "ı", "Ş": "ş", "Ğ": "ğ", "Ü": "ü", "Ö": "ö", "Ç": "ç"
        };
        str = str.replace(/([İIŞĞÜÖÇ])/g, function(char) { return letters[char] || char; });
        return str.toLowerCase();
    }

    // MOB GRUP ARAMA (hem grup adı hem mob id ile) - Türkçe karakter destekli
    const groupSearch = document.getElementById("groupSearch");
    const groupList = document.getElementById("groupList");
    if(groupSearch && groupList){
        groupSearch.addEventListener("input", function(){
            const query = turkishLower(groupSearch.value.trim());
            groupList.querySelectorAll(".group-list-item").forEach(function(li){
                const name = turkishLower(li.getAttribute('data-group-name') || "");
                const mobid = turkishLower(li.getAttribute('data-mob-id') || "");
                if(name.includes(query) || mobid.includes(query)){
                    li.style.display = "";
                }else{
                    li.style.display = "none";
                }
            });
        });
    }

    setRowHover();
});


document.addEventListener("DOMContentLoaded", function() {
    function turkishLower(str) {
        const letters = {"İ":"i","I":"ı","Ş":"ş","Ğ":"ğ","Ü":"ü","Ö":"ö","Ç":"ç"};
        str = str.replace(/([İIŞĞÜÖÇ])/g, function(char) { return letters[char] || char; });
        return str.toLowerCase();
    }
    var groupSearch = document.getElementById("groupSearch");
    var groupList = document.getElementById("groupList");
    var cancelSearchBtn = document.getElementById("cancelSearchBtn");
    if (groupSearch && groupList) {
        groupSearch.addEventListener("input", function(){
            var query = turkishLower(groupSearch.value.trim());
            groupList.querySelectorAll(".group-list-item").forEach(function(li){
                var name = turkishLower(li.getAttribute('data-group-name') || "");
                var mobid = turkishLower(li.getAttribute('data-mob-id') || "");
                var itemNames = turkishLower(li.getAttribute('data-item-names') || "");
                if (query === "" || query === "iptal" || query === "cancel") {
                    li.style.display = "";
                } else if (name.includes(query) || mobid.includes(query) || itemNames.includes(query)) {
                    li.style.display = "";
                } else {
                    li.style.display = "none";
                }
            });
        });
        if (cancelSearchBtn) {
            cancelSearchBtn.addEventListener("click", function() {
                groupSearch.value = "";
                groupList.querySelectorAll(".group-list-item").forEach(function(li){
                    li.style.display = "";
                });
            });
        }
    }
});